	device zxspectrum48

;	-- port 0x123B = 4667
;	-- bit 7 and 6 = new vram page selection ("00", "01" or "10")
;	-- bit 5 and 4 = layers order	"00" - new vram over vram (100% magenta is transparent)
;	--								"01" - vram over new vram (black with bright is transparent) ; out 9275,20:out 9531,colour
;	-- bit 3 = not used
;	-- bit 2 = 	"0" page selected is write only, ZX ROM visible at 0000-3FFF
;	--			"1" page selected is read and write, ZX ROM is disabled
;	-- bit 1 = 	"0" new vram not visible
;	-- bit 0 = 	"0" new vram read and write disabled

;-------------------------------
;Start	

	org	$8000
start
	ld a,7 			; black bg
	ld (23693),a
	call CLEARSCREEN
	ld a,1			; blue border
	call SETBORDER
	call setdrv
	call sproff
	call BitmapOn

	ld ix,sprfile	; load the warhawk sprites
	ld e,$00
	call loadspr

	ld bc,NEXT_WRITE
	ld a,21			; sprites and layers
	out (c),a
	inc b
	ld a,3
	out (c),a
	call openscreen

;-------------------------- Game loop	
loop

	ei
	call scankeys

	ld	d,192:call WaitYLine
	ld	a,1:call setTurbo

	call moveShip
	call drawShip
	call moveBullets
	call drawBullets

	call setNormal
	ld	a,(debkeys+KEY_ENTER)	; check for ENTER pressed
	and KEYAND_ENTER			; & with ENTER
	jr z,loop 					; if 0, loop
finish	
	call sproff
	ld	bc,4667
	xor a
	out (c),a
	ret

;Includes
;-------------------------------
	INCLUDE "Defines.asm"
 	INCLUDE "FileFunctions.asm"
 	INCLUDE "SpriteFunctions.asm"
 	INCLUDE "InputFunctions.asm"
 	INCLUDE "ScreenFunctions.asm"
 	INCLUDE "SpeedFunctions.asm"
;-------------------------------
drawShip
	ld bc,$303b:ld a,59:out (c),a 			; first sprite is 59 (+3)

	ld de, (warhawk_x)
	add e, (16)
	ld a, (warhawk_y)
	ld l,a 			; y
	ld a,128 + 0	; sprite
	ld c,a
	ld b,0			; sprite flags (flip and rotate)
	call SetSprite

	ld de, (warhawk_x)
	ld a,e
	add a,16
	ld e,a
	ld a, (warhawk_y)
	ld l,a	
	ld a,128 + 1	; sprite
	ld c,a
	ld b,0			; sprite flags (flip and rotate)	
	call SetSprite	

	ld de, (warhawk_x)
	ld a, (warhawk_y)
	add a,16
	ld l,a	
	ld a,128 + 16	; sprite
	ld c,a
	ld b,0			; sprite flags (flip and rotate)	
	call SetSprite		

	ld de, (warhawk_x)
	ld a,e
	add a,16
	ld e,a
	ld a, (warhawk_y)
	add a,16
	ld l,a	
	add l,16	
	ld a,128 + 17	; sprite
	ld c,a
	ld b,0			; sprite flags (flip and rotate)	
	call SetSprite	

	ret

;-------------------------------

moveShip
	ld	a,(oldkeys+KEY_O)
	and KEYAND_O
	jp z,.notLeft

	ld de, (warhawk_x)
	dec e
	ld (warhawk_x), de

.notLeft

	ld	a,(oldkeys+KEY_P)
	and KEYAND_P
	jp z,.notRight

	ld de, (warhawk_x)
	inc e
	ld (warhawk_x), de

.notRight

	ld	a,(oldkeys+KEY_Q)
	and KEYAND_Q
	jp z,.notUp

	ld de, (warhawk_y)
	dec e
	ld (warhawk_y), de

.notUp

	ld	a,(oldkeys+KEY_A)
	and KEYAND_A
	jp z,.notDown

	ld de, (warhawk_y)
	inc e
	ld (warhawk_y), de

.notDown
	; check for fire
	; if fire pressed, shoot
	; if fire is down and released, fire

	ld a,(oldkeys+KEY_SPACE)
	and KEYAND_SPACE
	jp z,.notFire

	ld a, (fireTrap)
	dec a 				; is firetrap 1?
	jp z,.fireDone

	ld a,1
	ld (fireTrap), a
	call fireBullet

	jp .fireDone

.notFire
	ld a, (fireTrap)
	or a 				; if filetrap was 0
	jp z,.fireDone		; button was not released
	call fireBullet 	; else, button was release, so fire again
	xor a
	ld (fireTrap), a 	; set firetrap to 0

.fireDone
	ret

;-------------------------------
fireBullet

	ld ix,Bullets:					; index x coord
	ld b, 7							; 8 bullets
.fireBulletLoop
	push bc

	ld a, (ix+bulleta)
	or a
	jp z,.foundBullet				; if 0, the bullet is free

	pop bc
	ld de, bulletl
	add ix,de
	dec d
	djnz .fireBulletLoop

	ret	
.foundBullet
	pop bc

	ld de, (warhawk_x)
	ld (ix+bulletx), de
	ld de, (warhawk_y)
	ld (ix+bullety), de
	ld (ix+bulleta),1

	ret

;-------------------------------
drawBullets
	; should add 'move' int same loop really

	ld bc,$303b:ld a,0:out (c),a 	; first sprite is 0

	ld ix,Bullets:					; index x coord
	ld b, 7							; 8 bullets
.bulletLoop
	push bc 						; store counter

	ld de, (ix+bulletx)				; t/l
	ld a, (ix+bullety)
	ld l,a 			; y
	ld a,128 + 2	; sprite
	ld c,a
	ld b, 0		; sprite flags (flip and rotate)
	call SetSprite

	ld de, (ix+bulletx)				; t/r
	ld a,e  
	add a,16
	ld e,a	
	ld a, (ix+bullety)
	ld l,a 			; y
	ld a,128 + 3	; sprite
	ld c,a
	ld b, 0		; sprite flags (flip and rotate)
	call SetSprite

	ld de, (ix+bulletx)				; b/l
	ld a, (ix+bullety)
	add a,16
	ld l,a 			; y
	ld a,128 + 18	; sprite
	ld c,a
	ld b, 0		; sprite flags (flip and rotate)
	call SetSprite

	ld de, (ix+bulletx)				; b/r
	ld a,e
	add a,16
	ld e,a	
	ld a, (ix+bullety)
	add a,16
	ld l,a 			; y
	ld a,128 + 19	; sprite
	ld c,a
	ld b, 0		; sprite flags (flip and rotate)
	call SetSprite

.bulletContinue	
	pop bc
	ld de, bulletl
	add ix,de
	dec d
	djnz .bulletLoop

	ret	
.bulletNotactive


;-------------------------------
moveBullets
	ld ix,Bullets:					; index x coord
	ld b, 7							; 8 bullets

.bulletMoveLoop
	push bc 						; store counter
	ld a, (ix+bulleta)
	or a
	jp z,.bulletMoveContinue		; if zero, bullet is not active

	ld a, (ix+bullety)
	sub 4
	jp nc,.bulletMoveActive

		ld (ix+bullety),0
		ld a, 0							; bullet off screen
		ld (ix+bulleta),0 				; set inactive

	jp .bulletMoveContinue

.bulletMoveActive 
	ld (ix+bullety), a

.bulletMoveContinue
	pop bc
	ld de, bulletl
	add ix,de
	dec d
	djnz .bulletMoveLoop

	ret

;-------------------------------
bulletx = 0
bullety = 2
bulleta = 4
bulletf = 5

bulletl = 6
; 8 bullets for nw
; each 4 sprites, 2,3,18,19
Bullets
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0
			db 0,0,0,0,0,0

warhawk_x	dw 160-16				; x coord
warhawk_y	db 192					; y coord

fireTrap	db 0
;------------------------------

; images

sprfile		db 		"warspr.spr",0


;---- Output snap file
	savesna "Warhawk.sna",start