; Thanks Jim

ToVRAM	push bc:ld a,d:and 192:or 3:ld bc,4667:out (c),a:ld a,d:and 63:ld d,a:pop bc:ldir
			ld	bc,4667:ld a,2:out (c),a:ret

plot		push bc:push af:ld a,d:and 192:or 3:ld bc,4667:out (c),a:ld a,d:and 63:ld d,a:pop af
			ld	bc,4667:ld a,2:out (c),a:pop bc:ret

;D = line
WaitYLine	ld	bc,$243b:ld a,30:out (c),a:inc b
.lp			in a,(c):and 1:jr nz,.lp
				ld	bc,$243b:ld a,31:out (c),a:inc b
.lp2			in a,(c):cp d:jr nz,.lp2
				ret

openscreen	ld a,2
			jp $1601

sprint		pop	hl:call print:jp (hl)
print		ld	a,(hl):inc hl:or a:ret z:bit 7,a:ret nz:rst 16::jr print
prtat		ld	a,22:rst 16:ld a,e:rst 16:ld a,d:jp 16
hextab		db	"0123456789ABCDEF"
space		ld	a," ":jp 16
prt_hex_16	ld	a,h:call prt_hex:ld a,l
prt_hex		push af:rra:rra:rra:rra:call prt_hex_4:pop af
prt_hex_4	push hl:and	15:add a,hextab&255:ld l,a:adc a,hextab/256:sub l:ld h,a:ld a,(hl):pop hl:jp 16
prt_dec		ld	bc,10000:call .dl:ld bc,1000:call .dl:ld bc,100:call .dl:ld bc,10:call .dl:ld a,l:add a,"0":jp 16
.dl			ld	a,"0"-1
.lp			inc a:or a:sbc hl,bc:jr	nc,.lp:add hl,bc:jp 16	

WaitVSync
	ld	d,128:call WaitYLine
	ld	a,1:call setTurbo

// other tools

; ************************************************************************
;
;	Function:	Set current bank **** WILL CHANGE ****
;			This banks in memory from the 2MB Ram to the top bank
;	In:		A = bank to set, paged into $c000
;
; ************************************************************************
SetBank:	push	bc
		ld	bc,$3ffd		; banking port  ***** WILL CHANGE ****
		out	(c),a
		pop	bc
		ret	

; ************************************************************************
;
;	Function:	Clear the 256 colour screen to a set colour
;	In:		A = colour to clear to ($E3 makes it transparent)
;
; ************************************************************************
Cls256:
		push	bc
		push	de
		push	hl

		ld	d,a			; byte to clear to
                ld	e,3			; number of blocks
                ld	a,1			; first bank... (bank 0 with write enable bit set)
                
                ld      bc, $123b                
@LoadAll:	out	(c),a			; bank in first bank
                push	af
                
                                
                ; Fill lower 16K with the desired byte
                ld	hl,0
@ClearLoop:	ld	(hl),d
                inc	l
                jr	nz,@ClearLoop
                inc	h
                ld	a,h
                cp	$40
                jr	nz,@ClearLoop

                pop	af			; get block back
                add	a,$40
                dec	e			; loops 3 times
                jr	nz,@LoadAll

                ld      bc, $123b		; switch off background (should probably do an IN to get the original value)
                ld	a,0
                out	(c),a     

                pop	hl
                pop	de
                pop	bc
                ret                          


; ************************************************************************
;
;	Function:	Clear the spectrum attribute screen
;	In:		A = attribute
;
; ************************************************************************
ClsATTR:
		push	hl
		push	bc
		push	de

	        ;ld      a,7
                ld      ($5800),a
                ld      hl,$5800
                ld      de,$5801
                ld      bc,1000
                ldir

                pop	de
                pop	bc
                pop	hl
                ret


; ************************************************************************
;
;	Function:	clear the normal spectrum screen
;
; ************************************************************************
Cls:
		push	hl
		push	bc
		push	de

		xor	a
                ld      ($4000),a
                ld      hl,$4000
                ld      de,$4001
                ld      bc,6143
                ldir

                pop	de
                pop	bc
                pop	hl
                ret



; ************************************************************************
;
;	Function:	Enable the 256 colour Layer 2 bitmap
;
; ************************************************************************
BitmapOn
                ld      bc, $123b
                ld	a,2
                out	(c),a     
                ret                          

               	
; ************************************************************************
;
;	Function:	Disable the 256 colour Layer 2 bitmap
;
; ************************************************************************
BitmapOff:
                ld      bc, $123b
                ld	a,0
                out	(c),a     
                ret          
